#!/bin/sh

MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_MSG=""
MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_OK=0
MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ERROR=1

MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_CODE=${MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ERROR}
MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ROLLING=0

master_page_esxi_info_update() {
    debug_print "in function '${FUNCNAME[0]}': sc_id='${to_be_updated_sc_id}'"

	local elem="cluster_${to_be_updated_sc_id}/esxi"
	
	# initial value
	local ip=`dtascfg "$DTASCFG_XML_FILE" get "$elem" ip`
	local username=`dtascfg "$DTASCFG_XML_FILE" get "$elem" username`
	local password=`dtascfg "$DTASCFG_XML_FILE" get "$elem" password`
	
	tp_ip_divider_username_password \
		"${MASTER_PAGE_ESXI_INFO_UPDATE_TITLE}" \
		"${MASTER_PAGE_ESXI_INFO_UPDATE_TEXT}" \
		"${MASTER_PAGE_ESXI_INFO_UPDATE_LABEL_OK}" \
		"${MASTER_PAGE_ESXI_INFO_UPDATE_LABEL_CANCEL}" \
        "${ip}" \
		"${username}" \
		"${password}"

    debug_print "TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE: ${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE}"
    case "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE}" in
    
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_ERROR}")
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ERROR
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ROLLING=0
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_MSG="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG}"
            return
            ;;
        
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CANCEL}")
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_OK
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ROLLING=-1
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_MSG=""
            return
            ;;
            
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ERROR
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ROLLING=0
            MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_MSG="${MASTER_PAGE_ESXI_INFO_UPDATE_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    # check esxi connection
    local msg
    msg=`/usr/bin/esxcli \
        --server     "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP}" \
        --portnumber 10443 \
        --username   "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_USERNAME}" \
        --password   "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_PASSWORD}"`
    local ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        debug_print "TerminateByCtrlC: ret='${ret}'"
        
        MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_CODE="${MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_OK}"
        MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ROLLING=0
        MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_MSG=""
        return
        
    elif [ "${ret}" -ne 0 ]; then
        MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_CODE="${MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ERROR}"
        MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ROLLING=0
        MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_MSG="${ERROR_ESXI_WRONG_USERNAME_PASSWORD}"
        return
    fi
    
	debug_print "SaveClusterEsxiConfIntoDb: scId='${to_be_updated_sc_id}', ip='${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP}', esxiUsername='${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_USERNAME}'"
	php $CONS_BACKEND save_cluster_esxi_conf \
        "${to_be_updated_sc_id}" \
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP}" \
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_USERNAME}" \
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_PASSWORD}"
	
	MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_OK
	MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_ROLLING=1
    MASTER_PAGE_ESXI_INFO_UPDATE_RESULT_MSG=""
}